<?php $__env->startSection('title'); ?>
    <?php echo e(__('Add Fund')); ?> <?php echo e(__('-')); ?> <?php echo e($settings->site_title); ?>

<?php $__env->stopSection(); ?>
 
<?php $__env->startSection('content'); ?>

<div class="deposits">
<!--- add funds --->
<div class="mx-auto my-10 mxa-4 overflow-hidden" style="max-width: 700px; overflow: hidden !important;">

<!--- add funds form --->
    <div class="rounded flex-no-shrink bg-white">
      <div class="text-left px-3 flex items-center">
        <h2 class="text-lg text-black py-2 font-normal fb">  <?php echo e(__('Add Money')); ?> </h2>
      </div>
      <hr>
    <form method="POST" action="<?php echo e(route('user.deposit.addfund')); ?>">
                        <?php echo csrf_field(); ?>
      <div class="p-2 md:p-3 add_money_form">
        <label class="">
          <div class="flex content-center items-center justify-between text-sm">
            <p class="block font-medium text-gray-700 dark:text-gray-200 font-primary"><?php echo e(__('Enter the amount')); ?></p>
          </div>
          <div class="mt-1 relative">
            <div class="relative">
              <input type="number" name="amount" id="amount"  placeholder="<?php echo e(__('Amount')); ?>" class="form-input relative block w-full disabled:cursor-not-allowed disabled:opacity-75 focus:outline-none border-0 rounded-md placeholder-gray-400 dark:placeholder-gray-500 text-sm px-3.5 py-2.5 shadow-sm bg-white dark:bg-gray-900 text-gray-900 dark:text-white ring-1 ring-inset ring-gray-300 dark:ring-gray-700 focus:ring-2 focus:ring-primary-500 dark:focus:ring-primary-400">
            </div>
          </div>
          <p class="text-red-500"></p>
        </label>
        <div class="text-center">
          <button type="submit" class="justify-center focus:outline-none disabled:cursor-not-allowed disabled:opacity-75 flex-shrink-0 font-medium rounded-md text-sm gap-x-1.5 px-2.5 py-2.5 shadow-sm text-white dark:text-gray-900 bg-primary-500 hover:bg-primary-600 disabled:bg-primary-500 dark:bg-primary-400 dark:hover:bg-primary-500 dark:disabled:bg-primary-400 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-500 dark:focus-visible:outline-primary-400 inline-flex items-center my-2 w-full text-center"><?php echo e(__('Click Here To Add Money')); ?></button>
        </div>
      </div>
  </form>
    </div>
<!--- /add funds form --->

<?php if(!empty($settings->add_money_video_link )): ?>
<!--- help video --->
    <div class="rounded bg-white my-4 md:my-10" style="border-radius: 0.375rem; border-width: 1px;">
      <div class="text-left px-3 flex items-center">
        <svg viewBox="0 0 24 24" class="text-green-100 mr-2" style="width: 22px; height: 22px;">
          <path fill="currentColor" d="M3 4V16H21V4H3M3 2H21C22.1 2 23 2.89 23 4V16C23 16.53 22.79 17.04 22.41 17.41C22.04 17.79 21.53 18 21 18H14V20H16V22H8V20H10V18H3C2.47 18 1.96 17.79 1.59 17.41C1.21 17.04 1 16.53 1 16V4C1 2.89 1.89 2 3 2M10.84 8.93C11.15 8.63 11.57 8.45 12 8.45C12.43 8.46 12.85 8.63 13.16 8.94C13.46 9.24 13.64 9.66 13.64 10.09C13.64 10.53 13.46 10.94 13.16 11.25C12.85 11.56 12.43 11.73 12 11.73C11.57 11.73 11.15 11.55 10.84 11.25C10.54 10.94 10.36 10.53 10.36 10.09C10.36 9.66 10.54 9.24 10.84 8.93M10.07 12C10.58 12.53 11.28 12.82 12 12.82C12.72 12.82 13.42 12.53 13.93 12C14.44 11.5 14.73 10.81 14.73 10.09C14.73 9.37 14.44 8.67 13.93 8.16C13.42 7.65 12.72 7.36 12 7.36C11.28 7.36 10.58 7.65 10.07 8.16C9.56 8.67 9.27 9.37 9.27 10.09C9.27 10.81 9.56 11.5 10.07 12M6 10.09C6.94 7.7 9.27 6 12 6C14.73 6 17.06 7.7 18 10.09C17.06 12.5 14.73 14.18 12 14.18C9.27 14.18 6.94 12.5 6 10.09Z"></path>
        </svg>
        <h2 class="text-lg text-black py-2 font-normal fb">  <?php echo e(__('How to add money')); ?> </h2>
      </div>
      <hr>
      <div class="flex-no-shrink p-2 mr-3 flex md:flex-row items-center flex-wrap justify-center sm:flex-col">
        <div class="w-full" align="center">
          <iframe src="<?php echo e($settings->add_money_video_link); ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" style="width: 100%; height: auto; min-height: 240px; min-width: 340px;"></iframe>
        </div>
      </div>
    </div>
<!--- /help video --->
<?php endif; ?> 

</div>
<!--- /add funds --->


<!--- deposits --->
      <div class="mx-auto container mx-auto text-center m-4">
  <div>
    <div>
      <div class="pxa-4 md:px-0">
        <div class="bg-white border rounded-lg overflow-hidden mx-auto mr-2" style="border-radius: 0.375rem; border-width: 1px">
          <div class="text-left px-3 flex items-center justify-between">
            <div class="flex items-center">
              <svg viewBox="0 0 24 24" class="mr-2" style="width: 24px; height: 24px">
                <path fill="currentColor" d="M11 15H17V17H11V15M9 7H7V9H9V7M11 13H17V11H11V13M11 9H17V7H11V9M9 11H7V13H9V11M21 5V19C21 20.1 20.1 21 19 21H5C3.9 21 3 20.1 3 19V5C3 3.9 3.9 3 5 3H19C20.1 3 21 3.9 21 5M19 5H5V19H19V5M9 15H7V17H9V15Z"></path>
              </svg>
              <h2 class="text-lg text-black py-2 font-normal fb"> <?php echo e(__('My Deposits')); ?></h2>
            </div>
          </div>
          <hr>
          <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <!--- item --->
          <div class="deposits-list border-b-2 m-2">
            <div class="sm:flex">
              <div class="w-full sm:w-1/2">
                <p class="px-3 py-1 text-left">
                  <span class="font-bold"><?php echo e(__(('Serial NO'))); ?>: </span> <?php echo e($deposit->id); ?>

                </p>
                <p class="px-3 py-1 text-left">
                  <span class="font-bold"><?php echo e(__(('Date'))); ?>: </span> <?php echo e(custom_date($deposit)); ?>

                </p>
                  <?php if(!empty($deposit->transaction->payment_method)): ?>
                <p class="px-3 py-1 text-left">
                  <span class="font-bold"><?php echo e(__(('Payment Method'))); ?>: </span> 
                                        <?php echo e($deposit->transaction->payment_method); ?>

                </p>
                <?php endif; ?>
              </div>
              <div class="w-full sm:w-1/2">
                                    <?php if(!empty($deposit->transaction->transaction_id)): ?>
                <p class="px-3 py-1 text-left">
                  <span class="font-bold"><?php echo e(__(('Transaction ID'))); ?>: </span>        
                                        <?php echo e($deposit->transaction->transaction_id); ?>

                </p>
                                    <?php endif; ?>
                <p class="px-3 py-1 text-left">
                  <span class="font-bold"><?php echo e(__(('Amount'))); ?>: </span> <?php echo e(price($deposit->amount)); ?>

                </p>
                <p class="px-3 py-1 text-left">
                  <span class="font-bold"><?php echo e(__(('Status'))); ?>: </span>

                <span class="<?php echo e(\App\Constants\DepositStatus::color($deposit->status)); ?>">
                  <span class="deposit-status"><?php echo e(strtolower($deposit->status)); ?></span> <?php if($deposit->isUnpaid()): ?> <a class="btn theme-btn btn-sm btn-right-mobile" style="padding: 3px 6px;" href="<?php echo e(route('user.deposit.pay', ['id' => $deposit->id])); ?>">
                    <?php echo e(__('Pay Now')); ?>

                  </a> <?php endif; ?> </span>


                        
                </p>
              </div>
            </div>
          </div>
          <!--- /item --->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="box-form mx-auto w-36 deposit-not-found">
          <h4 class="fb-normal text-base">No deposit found!</h4>
        </div> 
        <?php endif; ?>


        <?php if($deposits->lastPage() > 1): ?> 
          <p class="p-3 text-gray-800 text-center border border-b">
             <?php echo e($deposits->links('pagination')); ?>

          </p>
        <?php endif; ?>
          <!---->
        </div>
      </div>
    </div>
  </div>
</div>
<!--- /deposits --->
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('scripts.user.addfunds', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amartopu/public_html/core/resources/views/user/add-funds.blade.php ENDPATH**/ ?>