<?php $__env->startSection('title'); ?>
    <?php echo e($settings->home_title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div>
            <div class="p-2">
 
    <?php if($settings->enable_notice): ?>
        <div class="notice-container container m-auto">
            <div class="alert alert-light notice-style alert-dismissible fade show position-relative" role="alert">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                <div class="notice-heading"><?php echo e($settings->notice_title); ?></div>
                <div class="notice-text mb-0"><?php echo e($settings->notice_content); ?></div>
            </div>
        </div>
    <?php endif; ?>


<!--- slider --->
    <?php if(count($sliders) > 0): ?>

              <section class="container m-auto">
  <section class="carousel my-4" dir="ltr" aria-label="Gallery" tabindex="0" style="margin-bottom:10px !important;">
    <div class="carousel__viewport">
      <ol class="carousel__track" style="transform: translateX(0px); transition: all 0ms ease 0s;">

                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="carousel__slide">
          <div class="carousel__item">
                        <?php if(isset($slider->url)): ?>
             <a href="<?php echo e($slider->url); ?>" target="_blank">
              <img src="<?php echo e($slider->image_url); ?>" class="rounded-md">
            </a>
                        <?php else: ?>
              <img src="<?php echo e($slider->image_url); ?>" class="rounded-md">
                        <?php endif; ?>



          </div>
        </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

 
  
      </ol>
    </div>


    <button type="button" class="carousel__prev" aria-label="Navigate to previous slide">
      <svg class="carousel__icon" viewBox="0 0 24 24" role="img" aria-label="Arrow pointing to the left">
        <title>Arrow pointing to the left</title>
        <path d="M15.41 16.59L10.83 12l4.58-4.59L14 6l-6 6 6 6 1.41-1.41z"></path>
      </svg>
    </button>
    <button type="button" class="carousel__next" aria-label="Navigate to next slide">
      <svg class="carousel__icon" viewBox="0 0 24 24" role="img" aria-label="Arrow pointing to the right">
        <title>Arrow pointing to the right</title>
        <path d="M8.59 16.59L13.17 12 8.59 7.41 10 6l6 6-6 6-1.41-1.41z"></path>
      </svg>
    </button>
    <ol class="carousel__pagination">

<?php if(count($sliders) > 0): ?>
    <?php for($i = 1; $i <= count($sliders); $i++): ?>
        <li class="carousel__pagination-item">
            <button type="button" class="carousel__pagination-button <?php echo e($i == 1 ? 'carousel__pagination-button--active' : ''); ?>" aria-label="Navigate to slide <?php echo e($i); ?>"></button>
        </li>
    <?php endfor; ?>
<?php endif; ?>

    </ol>
  </section>
</section>

    <?php endif; ?>
          <!--- /slider --->


 <!--- products --->
          <section class="my-2" id="topup">
                <div class="container mx-auto">
                  <div class="text-center">
                    <div class="flex items-center justify-center px-4 mt-0 md:mt-2 section-contact-gap pb-4">
                      <hr role="separator" aria-orientation="horizontal" class="section-divider v-divider theme--light">
                      <h3 class="text-2xl sm:text-3xl text-center font-primary font-bold mx-4 text-secondary-900"><?php echo e(__('ALL ITEMS
')); ?></h3>
                      <hr role="separator" aria-orientation="horizontal" class="section-divider v-divider theme--light">
                    </div>
                  </div>

                  <div class="pb-1 md:pb-10">
                    <div class="md:py-5 md:px-0 grid md:grid-cols-6 sm:grid-cols-4 grid-cols-3 md:gap-8 gap-4">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
 <div class="single-game-product mb-2 md:mb-6">
                        <a href="<?php echo e(route('topup', ['slug' => $product->slug])); ?>" class="triangle">
                          <div class="cursor-pointer">
                            <div class="inset-0 opacity-25"></div>
                            <div class="inset-0 transform hover:scale-90 transition duration-300">
                              <div class="h-full w-full text-center mx-auto">
                                <img src="<?php echo e($product->image_url); ?>" width="200" height="100" alt="" data-nuxt-img="" sizes="(max-width: 640px) 100vw, (max-width: 768px) 50vw, 400px" srcset="<?php echo e($product->image_url); ?> 1w, <?php echo e($product->image_url); ?> 2w, <?php echo e($product->image_url); ?> 320w, <?php echo e($product->image_url); ?> 400w, <?php echo e($product->image_url); ?> 640w, <?php echo e($product->image_url); ?> 800w" class="rounded-md">
                              </div>
                            </div>
                          </div>
                          <div>
                            <h1 class="capitalize text-xs text-center pt-3 font-primary font-extralight text-secondary-500"><?php echo e($product->title); ?></h1>
                          </div>
                        </a>
                      </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                  </div>
              </div>
           </section>

    <script src="<?php echo e(asset('assets/template/js/slider.js')); ?>?1879"></script>
    
</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('scripts.popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .notice-style {
            background-color: <?php echo e($settings->notice_background_color); ?>;
            color: <?php echo e($settings->notice_font_color); ?>;
        }

        .notice-style .btn-close {
            font-size: 12px;
        }

        .notice-style .notice-heading {
            font-size: 18px;
            font-weight: 500;
            padding-bottom: 4px;
        }

        .notice-text {
            font-size: 12px;
            font-weight: 400;
            font-family: "Times New Roman", Times, serif;

        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amartopu/public_html/core/resources/views/home.blade.php ENDPATH**/ ?>